//--------------------------------------------------------------
// ChannelExpand
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( ChannelExpand, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 src = tex2D( Input, uv1 );

   float f = floor( ( frac( ( uv1.x * _Width ) / 4.0 ) * 4.0 ) + 0.5 );

   float4 ret = 0;

   if ( f == 0 )
      ret = src.b;
   else if ( f == 1 )
      ret = src.g;
   else if ( f == 2 )
      ret = src.r;
   else
      ret = src.a;

   ret.a = 1.0;

   return ret;
}

