//--------------------------------------------------------------//
// BGRAToBGR
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( BGRAToBGR, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 ret;

   // which group?
   int x = (int) (fmod( uv1.x * _Width * 0.75, 3.0 ));

   float4 src = tex2D(Input, uv1);
   float4 srcl = tex2D(Input, uv2);
   float4 srcr = tex2D(Input, uv3);

   if ( x == 0 )
   {
      ret.b = src.b;
      ret.g = src.g;
      ret.r = src.r;
      ret.a = srcr.b;
   }
   else if ( x == 1 )
   {
      ret.b = src.g;
      ret.g = src.r;
      ret.r = srcr.b;
      ret.a = srcr.g;
   }
   else if ( x == 2 )
   {
      ret.b = srcl.r;
      ret.g = src.b;
      ret.r = src.g;
      ret.a = src.r;
   }

   return ret;
}

