//--------------------------------------------------------------//
// ARGBToYUV422
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( ARGBToYUV422, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input );

float3x3 mYUV709n = { // Normalized
   0.2126, 0.7152, 0.0722,
   -0.1145721060573399, -0.3854278939426601, 0.5,
   0.5, -0.4541529083058166, -0.0458470916941834
};

DeclareEntryPoint()
{
   float4 in_rgba = tex2D( Input, uv1 );
   float4 temp;
   // debug
   temp.r = in_rgba.b;
   temp.g = in_rgba.g;
   temp.b = in_rgba.r;
   temp.a = in_rgba.a;

   in_rgba = temp;
   float4 ret;

   //16->16
   //ret = float4
   //(
   //0,
   //0.25,
   //0.5,
   //0.75
   //);

   // with alpha
   //ret = float4
   //(
   //   in_rgba.r * mYUV709n._m00 + in_rgba.g * mYUV709n._m01 + in_rgba.b * mYUV709n._m02,
   //   in_rgba.r * mYUV709n._m10 + in_rgba.g * mYUV709n._m11 + in_rgba.b * mYUV709n._m12,
   //   in_rgba.r * mYUV709n._m20 + in_rgba.g * mYUV709n._m21 + in_rgba.b * mYUV709n._m22,
   //   in_rgba.a
   //) + float4(0, 0.5, 0.5, 0);

   // First pixel (provides Y, Cr and Cb samples at this position)
   ret.bag = float3
      (
      in_rgba.r * mYUV709n._m00 + in_rgba.g * mYUV709n._m01 + in_rgba.b * mYUV709n._m02,
      in_rgba.r * mYUV709n._m10 + in_rgba.g * mYUV709n._m11 + in_rgba.b * mYUV709n._m12,
      in_rgba.r * mYUV709n._m20 + in_rgba.g * mYUV709n._m21 + in_rgba.b * mYUV709n._m22
      ) + float3(0, 0.5, 0.5);


   // Second pixel (Provides Y-sample at this position only)
   ret.r = in_rgba.r * mYUV709n._m00 + in_rgba.g * mYUV709n._m01 + in_rgba.b * mYUV709n._m02;

   return ret;
}

