//--------------------------------------------------------------//
// ARGBToYUV
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( ARGBToYUV, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input );

DeclareFloatParam( _Width );

// Note that :
// 1. The Y value ranges from 16 to 235 (220 levels), with 16 being black.
// 2. The Cr and Cb values range from 16 to 240 with 128 as the mid - point.
// 3. The above are for 8 - bit values. 10 - bit values can be acheived by multiplying the decimal values by 4.
// 4. The values in brackets are in hexadecimal.

DeclareEntryPoint()
{
   float4 in_rgba = tex2D( Input, uv1 );

   float4 ret;

   int pix = (int) fmod( uv1.x * _Width, _Width / 8 );

   if ( pix == 0 )
      ret = pix / 65536.0;
   else if ( pix == 1 )
      ret = pix / 65536.0;
   else if ( pix == 2 )
      ret = pix / 65536.0;
   else if ( pix == 3 )
      ret = pix / 65536.0;
   else if ( pix == 4 )
      ret = pix / 65536.0;
   else if ( pix == 5 )
      ret = pix / 65536.0;
   else if ( pix == 6 )
      ret = pix / 65536.0;
   else if ( pix == 7 )
      ret = pix / 65536.0;

   return ret;
}

