/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.SemVer;
import net.sf.mpxj.phoenix.Phoenix4Reader;
import net.sf.mpxj.phoenix.Phoenix5Reader;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class PhoenixReader
extends AbstractProjectStreamReader {
    private boolean m_useActivityCodesForTaskHierarchy = true;
    private static final int BUFFER_SIZE = 512;
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*<project.* version=\"((?:\\d\\.)*\\d*)\".*", 32);
    private static final SemVer VERSION_4 = new SemVer(4);
    private static final SemVer VERSION_5 = new SemVer(5);

    public boolean getUseActivityCodesForTaskHierarchy() {
        return this.m_useActivityCodesForTaskHierarchy;
    }

    public void setUseActivityCodesForTaskHierarchy(boolean useActivityCodesForTaskHierarchy) {
        this.m_useActivityCodesForTaskHierarchy = useActivityCodesForTaskHierarchy;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return null;
            }
            Matcher matcher = VERSION_PATTERN.matcher(new String(buffer, CharsetHelper.UTF8));
            SemVer version = matcher.find() ? new SemVer(matcher.group(1)) : VERSION_4;
            return (version.before(VERSION_5) ? new Phoenix4Reader(this.m_useActivityCodesForTaskHierarchy) : new Phoenix5Reader(this.m_useActivityCodesForTaskHierarchy)).read(bis);
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Collections.singletonList(this.read(inputStream));
    }
}

