/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.parser.raw;

import com.rtfparserkit.parser.IRtfListener;
import com.rtfparserkit.parser.IRtfParser;
import com.rtfparserkit.parser.IRtfSource;
import com.rtfparserkit.parser.raw.ByteBuffer;
import com.rtfparserkit.rtf.Command;
import com.rtfparserkit.utils.HexUtils;
import java.io.EOFException;
import java.io.IOException;

public class RawRtfParser
implements IRtfParser {
    private IRtfSource source;
    private int groupDepth;
    private boolean parsingHex;
    private ByteBuffer buffer;
    private IRtfListener listener;
    private static final int MAX_PARAMETER_LENGTH = 20;
    private static final int MAX_COMMAND_LENGTH = 30;

    @Override
    public void parse(IRtfSource source, IRtfListener listener) throws IOException {
        int ch;
        this.source = source;
        this.listener = listener;
        this.groupDepth = 0;
        this.parsingHex = false;
        this.buffer = new ByteBuffer();
        listener.processDocumentStart();
        this.parsingHex = false;
        block7: while ((ch = source.read()) != -1) {
            if (this.groupDepth < 0) {
                throw new IllegalStateException("Group stack underflow");
            }
            switch (ch) {
                case 123: {
                    this.handleGroupStart();
                    continue block7;
                }
                case 125: {
                    this.handleGroupEnd();
                    continue block7;
                }
                case 92: {
                    this.handleCommand();
                    continue block7;
                }
                case 10: 
                case 13: {
                    continue block7;
                }
                case 9: {
                    this.handleCharacterData();
                    listener.processCommand(Command.tab, 0, false, false);
                    continue block7;
                }
            }
            this.handleCharacterByte(ch);
        }
        if (this.groupDepth < 0) {
            throw new IllegalStateException("Group stack underflow");
        }
        if (this.groupDepth > 0) {
            throw new IllegalStateException("Unmatched brace");
        }
        listener.processDocumentEnd();
    }

    private void handleCharacterByte(int ch) throws IOException {
        if (this.parsingHex) {
            int b = HexUtils.parseHexDigit(ch) << 4;
            ch = this.source.read();
            if (ch == -1) {
                throw new IllegalStateException("Unexpected end of file");
            }
            if (ch == 92) {
                b >>= 4;
                this.source.unread(ch);
            } else {
                b += HexUtils.parseHexDigit(ch);
            }
            this.buffer.add(b);
            this.parsingHex = false;
        } else {
            this.buffer.add(ch);
        }
    }

    private void handleCommand() throws IOException {
        boolean commandHasParameter = false;
        boolean parameterIsNegative = false;
        int parameterValue = 0;
        StringBuilder commandText = new StringBuilder();
        StringBuilder parameterText = new StringBuilder();
        int ch = this.source.read();
        if (ch == -1) {
            throw new EOFException();
        }
        commandText.append((char)ch);
        if (!Character.isLetter(ch)) {
            this.handleCommand(commandText, 0, commandHasParameter);
            return;
        }
        while ((ch = this.source.read()) != -1 && Character.isLetter(ch)) {
            commandText.append((char)ch);
            if (commandText.length() <= 30) continue;
        }
        if (ch == -1) {
            throw new EOFException();
        }
        if (commandText.length() > 30) {
            throw new IllegalArgumentException("Invalid keyword: " + commandText.toString());
        }
        if (ch == 45) {
            parameterIsNegative = true;
            ch = this.source.read();
            if (ch == -1) {
                throw new EOFException();
            }
        }
        if (Character.isDigit(ch)) {
            commandHasParameter = true;
            parameterText.append((char)ch);
            while ((ch = this.source.read()) != -1 && Character.isDigit(ch)) {
                parameterText.append((char)ch);
                if (parameterText.length() <= 20) continue;
            }
            if (parameterText.length() > 20) {
                throw new IllegalArgumentException("Invalid parameter: " + parameterText.toString());
            }
            parameterValue = Integer.parseInt(parameterText.toString());
            if (parameterIsNegative) {
                parameterValue = -parameterValue;
            }
        }
        if (ch != 32) {
            this.source.unread(ch);
        }
        this.handleCommand(commandText, parameterValue, commandHasParameter);
    }

    private void handleCommand(StringBuilder commandBuffer, int parameter, boolean hasParameter) throws IOException {
        String commandName = commandBuffer.toString();
        Command command = Command.getInstance(commandName);
        if (command != null) {
            if (command != Command.hex) {
                this.handleCharacterData();
            }
            switch (command) {
                case bin: {
                    this.handleBinaryData(parameter);
                    break;
                }
                case hex: {
                    this.parsingHex = true;
                    break;
                }
                default: {
                    this.listener.processCommand(command, parameter, hasParameter, false);
                }
            }
        }
    }

    private void handleCharacterData() {
        byte[] data = this.buffer.toArray();
        this.buffer.clear();
        this.listener.processCharacterBytes(data);
    }

    private void handleBinaryData(int size) throws IOException {
        byte[] data = new byte[size];
        int bytesRead = this.source.read(data);
        if (bytesRead != size) {
            throw new EOFException();
        }
        this.listener.processBinaryBytes(data);
    }

    private void handleGroupStart() {
        this.handleCharacterData();
        ++this.groupDepth;
        this.listener.processGroupStart();
    }

    private void handleGroupEnd() {
        this.handleCharacterData();
        this.listener.processGroupEnd();
        --this.groupDepth;
    }
}

